<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Parcel;

use InPost\International\Enum\StringEnum;
use InPost\International\Translation\TranslatableInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self Standard()
 */
final class ParcelType extends StringEnum implements TranslatableInterface
{
    private const STANDARD = 'STANDARD';

    public function trans(TranslatorInterface $translator, string $locale = null): string
    {
        switch ($this) {
            case self::Standard():
                return $translator->trans('Standard', [], 'Modules.Inpostinternational.Shipment', $locale);
            default:
                return $this->name;
        }
    }
}
