<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Parcel;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Weight
{
    /**
     * @var float
     */
    private $amount;

    /**
     * @var WeightUnit
     */
    private $unit;

    public function __construct(float $amount, WeightUnit $unit)
    {
        $this->amount = $amount;
        $this->unit = $unit;
    }

    public function getAmount(): float
    {
        return $this->amount;
    }

    public function getUnit(): WeightUnit
    {
        return $this->unit;
    }
}
