<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model\Parcel;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self Gram()
 * @method static self Kilogram()
 */
final class WeightUnit extends StringEnum
{
    private const GRAM = 'G';
    private const KILOGRAM = 'KG';

    public static function getDefault(): self
    {
        return self::Kilogram();
    }

    public function getSymbol(): string
    {
        return strtolower($this->value);
    }

    public function convert(float $weight, self $toUnit): float
    {
        if ($this === $toUnit) {
            return $weight;
        }

        return $weight * $this->getMultiplier() / $toUnit->getMultiplier();
    }

    public function getMultiplier(): float
    {
        switch ($this) {
            case self::Gram():
                return 1.;
            case self::Kilogram():
                return 1000.;
            default:
                throw new \LogicException('Not implemented');
        }
    }
}
