<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @implements \IteratorAggregate<string, string>
 */
final class References implements \IteratorAggregate, \JsonSerializable
{
    /**
     * @var string[]
     */
    private $references;

    /**
     * @param array<string, string> $references
     */
    public function __construct(array $references)
    {
        $this->references = $references;
    }

    public function getReferences(): array
    {
        return $this->references;
    }

    public function getIterator(): \ArrayIterator
    {
        return new \ArrayIterator($this->references);
    }

    /**
     * @return array<string, mixed>
     */
    public function jsonSerialize(): array
    {
        return ['custom' => $this->references];
    }
}
