<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Model;

use InPost\International\Api\Shipment\Model\Service\Insurance;
use InPost\International\Country;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ValueAddedServices
{
    /**
     * @var Insurance|null
     */
    private $insurance;

    public function __construct(Insurance $insurance = null)
    {
        $this->insurance = $insurance;
    }

    public function getInsurance(): ?Insurance
    {
        return $this->insurance;
    }

    /**
     * @internal
     */
    public static function isInsuranceAvailable(Country $destination): bool
    {
        switch ($destination) {
            case Country::Hungary():
            case Country::Austria():
                return false;
            default:
                return true;
        }
    }
}
