<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreateShipmentRequest
{
    /**
     * @var LabelFormat
     */
    private $labelFormat;

    /**
     * @var ShipmentInterface
     */
    private $shipment;

    public function __construct(LabelFormat $labelFormat, ShipmentInterface $shipment)
    {
        $this->labelFormat = $labelFormat;
        $this->shipment = $shipment;
    }

    public function getLabelFormat(): LabelFormat
    {
        return $this->labelFormat;
    }

    public function getShipment(): ShipmentInterface
    {
        return $this->shipment;
    }
}
