<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Request;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self Pdf()
 * @method static self QuickSendCode()
 */
final class LabelFormat extends StringEnum
{
    private const PDF = 'PDF_URL';
    private const QUICK_SEND_CODE = 'QUICK_SEND_CODE';
}
