<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Parcel
{
    /**
     * @var string
     */
    private $uuid;

    /**
     * @var string[]
     */
    private $parcelNumbers;

    /**
     * @param array<string, string> $parcelNumbers
     */
    public function __construct(string $uuid, array $parcelNumbers)
    {
        $this->uuid = $uuid;
        $this->parcelNumbers = $parcelNumbers;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    /**
     * @return array<string, string>
     */
    public function getParcelNumbers(): array
    {
        return $this->parcelNumbers;
    }
}
