<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Routing
{
    /**
     * @var string
     */
    private $deliveryArea;

    /**
     * @var string
     */
    private $deliveryDepotNumber;

    public function __construct(string $deliveryDepotNumber, string $deliveryArea = null, string $deliverArea = null)
    {
        // according to the API documentation, the response should contain a "deliveryArea" field, but as of writing this comment, the API returns a "deliverArea" field
        $deliveryArea = $deliveryArea ?? $deliverArea ?? '';
        $this->deliveryArea = $deliveryArea;
        $this->deliveryDepotNumber = $deliveryDepotNumber;
    }

    public function getDeliveryArea(): string
    {
        return $this->deliveryArea;
    }

    public function getDeliveryDepotNumber(): string
    {
        return $this->deliveryDepotNumber;
    }
}
