<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Shipment
{
    /**
     * @var ShipmentLabel|null
     */
    private $label;

    /**
     * @var string
     */
    private $uuid;

    /**
     * @var string
     */
    private $trackingNumber;

    /**
     * @var Parcel
     */
    private $parcel;

    /**
     * @var string
     */
    private $status;

    /**
     * @var Routing|null
     */
    private $routing;

    public function __construct(string $uuid, string $trackingNumber, Parcel $parcel, string $status, ShipmentLabel $label = null, Routing $routing = null)
    {
        $this->label = $label;
        $this->uuid = $uuid;
        $this->trackingNumber = $trackingNumber;
        $this->parcel = $parcel;
        $this->status = $status;
        $this->routing = $routing;
    }

    /**
     * @return ShipmentLabel|null
     */
    public function getLabel(): ?ShipmentLabel
    {
        return $this->label;
    }

    public function getUuid(): string
    {
        return $this->uuid;
    }

    public function getTrackingNumber(): string
    {
        return $this->trackingNumber;
    }

    public function getStatus(): string
    {
        return $this->status;
    }

    public function getParcel(): Parcel
    {
        return $this->parcel;
    }

    public function getRouting(): ?Routing
    {
        return $this->routing;
    }
}
