<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment;

use InPost\International\Enum\StringEnum;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @method static self PointToPoint()
 * @method static self AddressToPoint()
 * @method static self PointToAddress()
 * @method static self AddressToAddress()
 */
final class ShipmentType extends StringEnum
{
    private const POINT_TO_POINT = 'point-to-point';
    private const ADDRESS_TO_POINT = 'address-to-point';
    private const POINT_TO_ADDRESS = 'point-to-address';
    private const ADDRESS_TO_ADDRESS = 'address-to-address';
}
