<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Shipment;

use InPost\International\Api\Shipment\Request\CreateShipmentRequest;
use InPost\International\Api\Shipment\Response\Label;
use InPost\International\Api\Shipment\Response\Shipment;
use Symfony\Component\Messenger\Exception\ValidationFailedException;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface ShipmentsApiClientInterface
{
    public const SCOPE_SHIPMENTS_WRITE = 'api:shipments:write';

    /**
     * Create a new shipment
     *
     * @throws ValidationFailedException
     */
    public function createShipment(CreateShipmentRequest $request): Shipment;

    /**
     * Get shipment details by UUID
     */
    public function getShipment(string $uuid): Shipment;

    /**
     * Get shipment label by UUID
     */
    public function getShipmentLabel(string $uuid): Label;
}
