<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Tracking\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Delivery
{
    /**
     * @var string|null
     */
    private $recipientName;

    /**
     * @var string|null
     */
    private $deliveryNotes;

    public function __construct(string $recipientName = null, string $deliveryNotes = null)
    {
        $this->recipientName = $recipientName;
        $this->deliveryNotes = $deliveryNotes;
    }

    public function getRecipientName(): ?string
    {
        return $this->recipientName;
    }

    public function getDeliveryNotes(): ?string
    {
        return $this->deliveryNotes;
    }
}
