<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Tracking\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Event
{
    /**
     * @var \DateTimeImmutable
     */
    private $timestamp;

    /**
     * @var string
     */
    private $code;

    /**
     * @var string|null
     */
    private $status;

    /**
     * @var string
     */
    private $id;

    /**
     * @var Location|null
     */
    private $location;

    public function __construct(\DateTimeImmutable $eventTimestamp, string $eventCode, string $eventId, string $status = null, Location $location = null)
    {
        $this->timestamp = $eventTimestamp;
        $this->code = $eventCode;
        $this->status = $status;
        $this->id = $eventId;
        $this->location = $location;
    }

    public function getTimestamp(): \DateTimeImmutable
    {
        return $this->timestamp;
    }

    public function getCode(): string
    {
        return $this->code;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getLocation(): ?Location
    {
        return $this->location;
    }
}
