<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Tracking\Model;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Location
{
    /**
     * @var string|null
     */
    private $id;

    /**
     * @var string|null
     */
    private $address;

    /**
     * @var string|null
     */
    private $city;

    /**
     * @var string|null
     */
    private $country;

    /**
     * @var string|null
     */
    private $name;

    /**
     * @var string|null
     */
    private $postalCode;

    /**
     * @var string
     */
    private $type;

    /**
     * @var string|null
     */
    private $description;

    public function __construct(string $type, string $id = null, string $address = null, string $city = null, string $country = null, string $name = null, string $postalCode = null, string $description = null)
    {
        $this->id = $id;
        $this->address = $address;
        $this->city = $city;
        $this->country = $country;
        $this->name = $name;
        $this->postalCode = $postalCode;
        $this->type = $type;
        $this->description = $description;
    }

    public function getId(): ?string
    {
        return $this->id;
    }

    public function getAddress(): ?string
    {
        return $this->address;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function getCountry(): ?string
    {
        return $this->country;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }
}
