<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Api\Tracking\Response;

use InPost\International\Api\Tracking\Model\Parcel;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class TrackingDetailsResponse
{
    /**
     * @var Parcel[]
     */
    private $parcels;

    /**
     * @param Parcel[] $parcels
     */
    public function __construct(array $parcels)
    {
        $this->parcels = $parcels;
    }

    /**
     * @return Parcel[]
     */
    public function getParcels(): array
    {
        return $this->parcels;
    }

    public function getParcel(string $trackingNumber): ?Parcel
    {
        foreach ($this->parcels as $parcel) {
            if ($trackingNumber !== $parcel->getTrackingNumber()) {
                continue;
            }

            return $parcel;
        }

        return null;
    }
}
