<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset;

use PrestaShop\PrestaShop\Core\Context\LegacyControllerContext;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class AdminAssetManager extends AbstractAssetManager
{
    /**
     * @var \Context
     */
    private $context;

    public function __construct(\Module $module, \Context $context)
    {
        parent::__construct($module);

        $this->context = $context;
    }

    protected function registerJavaScript(string $path, array $options = []): void
    {
        $url = $this->getPackage()->getUrl($path);
        $this->getController()->addJS($url);
    }

    protected function registerStyleSheet(string $path, array $options = []): void
    {
        $url = $this->getPackage()->getUrl($path);
        $this->getController()->addCSS($url, $options['media'] ?? 'all', null, false);
    }

    protected function getBasePath(): string
    {
        return sprintf('%s/views', rtrim($this->module->getPathUri(), '/'));
    }

    /**
     * @return \AdminController|LegacyControllerContext
     */
    private function getController()
    {
        return $this->context->controller;
    }
}
