<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Assets
{
    /**
     * @var array<string, array<string, mixed>>
     */
    private $javaScripts = [];

    /**
     * @var array<string, array<string, mixed>>
     */
    private $styleSheets = [];

    /**
     * @var array<string, mixed>
     */
    private $jsVariables = [];

    /**
     * @return array<string, array<string, mixed>> options by path
     */
    public function getJavaScripts(): array
    {
        return $this->javaScripts;
    }

    /**
     * @param array<string, mixed> $options
     */
    public function addJavaScript(string $path, array $options = []): self
    {
        $this->javaScripts[$path] = $options;

        return $this;
    }

    /**
     * @return array<string, array<string, mixed>> options by path
     */
    public function getStyleSheets(): array
    {
        return $this->styleSheets;
    }

    /**
     * @param array<string, mixed> $options
     */
    public function addStyleSheet(string $path, array $options = []): self
    {
        $this->styleSheets[$path] = $options;

        return $this;
    }

    /**
     * @return array<string, mixed> values by name
     */
    public function getJavaScriptVariables(): array
    {
        return $this->jsVariables;
    }

    /**
     * @return mixed|null
     */
    public function getJavaScriptVariable(string $name)
    {
        return $this->jsVariables[$name] ?? null;
    }

    /**
     * @param mixed $value
     */
    public function addJavaScriptVariable(string $name, $value): self
    {
        $this->jsVariables[$name] = $value;

        return $this;
    }

    public function merge(self $assets): self
    {
        $this->javaScripts = array_merge($this->javaScripts, $assets->javaScripts);
        $this->styleSheets = array_merge($this->styleSheets, $assets->styleSheets);
        $this->jsVariables = array_merge_recursive($this->jsVariables, $assets->jsVariables);

        return $this;
    }
}
