<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset\Event;

use InPost\International\Hook\Event\AbstractActionHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class FrontControllerAssetsRegisteredEvent extends AbstractActionHook
{
    public const NAME = 'actionFrontControllerSetMedia';

    public function __construct(Request $request = null)
    {
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }
}
