<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset\EventListener;

use InPost\International\Asset\AssetManagerInterface;
use InPost\International\Asset\Event\AdminControllerAssetsRegisteredEvent;
use Symfony\Component\Asset\Packages;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class RegisterPackageListener implements EventSubscriberInterface
{
    /**
     * @var Packages
     */
    private $packages;

    /**
     * @var AssetManagerInterface
     */
    private $assetManager;

    /**
     * @var string
     */
    private $packageName;

    public function __construct(Packages $packages, AssetManagerInterface $assetManager, string $packageName)
    {
        $this->packages = $packages;
        $this->assetManager = $assetManager;
        $this->packageName = $packageName;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            AdminControllerAssetsRegisteredEvent::NAME => 'onAssetsRegistered',
        ];
    }

    public function onAssetsRegistered(): void
    {
        $this->packages->addPackage($this->packageName, $this->assetManager->getPackage());
    }
}
