<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset\Filter;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface AssetOptionsFilterInterface
{
    /**
     * @param array<string, mixed> $options
     *
     * @return array<string, mixed> filtered options
     */
    public function filterJavaScriptOptions(array $options): array;

    /**
     * @param array<string, mixed> $options
     *
     * @return array<string, mixed> filtered options
     */
    public function filterStyleSheetOptions(array $options): array;
}
