<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Asset\Provider;

use InPost\International\Asset\Assets;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ChainAssetsProvider implements AssetsProviderInterface
{
    /**
     * @var iterable<AssetsProviderInterface>
     */
    private $providers;

    /**
     * @param iterable<AssetsProviderInterface> $providers
     */
    public function __construct(iterable $providers)
    {
        $this->providers = $providers;
    }

    public function getAssets(): Assets
    {
        $assets = new Assets();

        foreach ($this->providers as $provider) {
            $assets->merge($provider->getAssets());
        }

        return $assets;
    }
}
