<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier;

use Doctrine\Common\Collections\Selectable;
use Doctrine\Persistence\ObjectRepository;
use InPost\International\Entity\Carrier;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends ObjectRepository<Carrier>
 * @extends Selectable<int, Carrier>
 */
interface CarrierRepositoryInterface extends ObjectRepository, Selectable
{
    public function add(Carrier $entity): void;

    public function remove(Carrier $entity): void;
}
