<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Configurator;

use InPost\International\Carrier\CarrierConfiguration;
use InPost\International\Carrier\Message\CreateCarrierCommand;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ChainConfigurator implements CarrierConfiguratorInterface
{
    /**
     * @var iterable<CarrierConfiguratorInterface>
     */
    private $configurators;

    /**
     * @param iterable<CarrierConfiguratorInterface> $configurators
     */
    public function __construct(iterable $configurators)
    {
        $this->configurators = $configurators;
    }

    public function configure(CarrierConfiguration $configuration, CreateCarrierCommand $command): void
    {
        foreach ($this->configurators as $configurator) {
            assert($configurator instanceof CarrierConfiguratorInterface);
            $configurator->configure($configuration, $command);
        }
    }
}
