<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Configurator;

use InPost\International\Carrier\CarrierConfiguration;
use InPost\International\Carrier\Message\CreateCarrierCommand;
use InPost\International\PrestaShop\Module\ModuleRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PaymentOptionsConfigurator implements CarrierConfiguratorInterface
{
    /**
     * @var ModuleRepository
     */
    private $moduleRepository;

    /**
     * @var string[]
     */
    private $cashOnDeliveryModuleNames;

    /**
     * @param string[] $cashOnDeliveryModuleNames {@see \PaymentModule} names
     */
    public function __construct(ModuleRepository $moduleRepository, array $cashOnDeliveryModuleNames)
    {
        $this->moduleRepository = $moduleRepository;
        $this->cashOnDeliveryModuleNames = $cashOnDeliveryModuleNames;
    }

    public function configure(CarrierConfiguration $configuration, CreateCarrierCommand $command): void
    {
        if ([] === $moduleIds = $this->getCodModuleIds()) {
            return;
        }

        $configuration->setDisallowedPaymentModuleIds($moduleIds);
    }

    /**
     * @return int[]
     */
    private function getCodModuleIds(): array
    {
        return array_filter(array_map(function (string $moduleName): ?int {
            return $this->moduleRepository->getIdByName($moduleName);
        }, $this->cashOnDeliveryModuleNames));
    }
}
