<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Form;

use InPost\International\Carrier\CarrierType;
use InPost\International\Country;
use InPost\International\Enum\Form\Type\EnumType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormInterface;
use Symfony\Component\Form\FormView;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class EditCarrierType extends AbstractType
{
    /**
     * @var TranslatorInterface
     */
    private $translator;

    public function __construct(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
     * @param array{carrier_type: CarrierType} $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('countries', EnumType::class, [
                'class' => Country::class,
                'choices' => $options['carrier_type']->getPossibleDestinationCountries(),
                'multiple' => true,
                'expanded' => true,
                'label' => $this->translator->trans('Countries', [], 'Admin.Global'),
                'block_prefix' => 'material_choice_table',
            ]);
    }

    public function finishView(FormView $view, FormInterface $form, array $options): void
    {
        $view['countries']->vars['isCheckSelectAll'] = false;
        $view['countries']->vars['displayTotalItems'] = false;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setRequired('carrier_type')
            ->setAllowedTypes('carrier_type', CarrierType::class);
    }
}
