<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Grid;

use PrestaShop\PrestaShop\Core\FeatureFlag\FeatureFlagStateCheckerInterface;
use Symfony\Component\Routing\Exception\RouteNotFoundException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @internal
 */
class NewCarriersPageFlagChecker
{
    /**
     * @var UrlGeneratorInterface
     */
    private $urlGenerator;

    /**
     * @var FeatureFlagStateCheckerInterface
     */
    private $flagStateChecker;

    public function __construct(UrlGeneratorInterface $urlGenerator, FeatureFlagStateCheckerInterface $flagStateChecker)
    {
        $this->urlGenerator = $urlGenerator;
        $this->flagStateChecker = $flagStateChecker;
    }

    public function isEnabled(): bool
    {
        try {
            $this->urlGenerator->generate('admin_carriers_edit', [
                'carrierId' => 1,
            ]);
        } catch (RouteNotFoundException $e) {
            return false;
        }

        return $this->flagStateChecker->isEnabled('carrier');
    }
}
