<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Message;

use InPost\International\Carrier\CarrierType;
use InPost\International\Country;
use InPost\International\Validator\Unique;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CreateCarrierCommand
{
    /**
     * @var CarrierType|null
     *
     * @Assert\NotNull
     */
    private $type;

    /**
     * @var string|null
     *
     * @Assert\NotNull
     * @Assert\Length(max=64)
     */
    private $name = 'InPost International';

    /**
     * @var Country[]
     *
     * @Assert\Count(min=1)
     * @Unique
     * @Assert\All(
     *     @Assert\Type(Country::class),
     * )
     */
    private $countries = [];

    public function getType(): ?CarrierType
    {
        return $this->type;
    }

    public function setType(?CarrierType $type): void
    {
        $this->type = $type;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return Country[]
     */
    public function getCountries(): array
    {
        return $this->countries;
    }

    /**
     * @param Country[] $countries
     */
    public function setCountries(array $countries): void
    {
        $this->countries = $countries;
    }
}
