<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Message;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DeleteCarrierCommand
{
    /**
     * @var int
     */
    private $carrierId;

    public function __construct(int $carrierId)
    {
        $this->carrierId = $carrierId;
    }

    public function getCarrierId(): int
    {
        return $this->carrierId;
    }
}
