<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Carrier\Message;

use InPost\International\Country;
use InPost\International\Entity\Carrier;
use InPost\International\Validator\Unique;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class EditCarrierCommand
{
    /**
     * @var int
     */
    private $carrierId;

    /**
     * @var Country[]|null
     *
     * @Assert\Count(min=1)
     * @Unique
     * @Assert\All(
     *     @Assert\Type(Country::class),
     * )
     */
    private $countries;

    public function __construct(int $carrierId)
    {
        $this->carrierId = $carrierId;
    }

    public static function for(Carrier $carrier): self
    {
        $command = new self($carrier->getReferenceId());
        $command->setCountries($carrier->getCountries());

        return $command;
    }

    public function getCarrierId(): int
    {
        return $this->carrierId;
    }

    /**
     * @return Country[]|null
     */
    public function getCountries(): ?array
    {
        return $this->countries;
    }

    /**
     * @param Country[]|null $countries
     */
    public function setCountries(?array $countries): void
    {
        $this->countries = $countries;
    }
}
