<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Asset;

use InPost\International\Asset\Assets;
use InPost\International\Asset\Provider\AssetsProviderInterface;
use Symfony\Contracts\Translation\TranslatorInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CommonAssetsProvider implements AssetsProviderInterface
{
    public const ROUTES_VAR_NAME = 'inPostIntlRoutes';
    public const MISSING_PICKUP_POINT_ERROR = 'inPostIntlMissingPickupPointError';

    /**
     * @var \Context
     */
    private $context;

    /**
     * @param TranslatorInterface $translator
     */
    private $translator;

    public function __construct(\Context $context, TranslatorInterface $translator)
    {
        $this->context = $context;
        $this->translator = $translator;
    }

    public function getAssets(): Assets
    {
        return (new Assets())
            ->addStyleSheet('css/front/checkout.css')
            ->addJavaScriptVariable(self::ROUTES_VAR_NAME, [
                'updateDeliveryOptions' => $this->context->link->getModuleLink(\InPostInternational::MODULE_NAME, 'checkout', [
                    'action' => 'updateDeliveryOptions',
                ]),
                'findClosestPoint' => $this->context->link->getModuleLink(\InPostInternational::MODULE_NAME, 'checkout', [
                    'action' => 'findClosestPoint',
                ]),
                'validatePhoneNumber' => $this->context->link->getModuleLink(\InPostInternational::MODULE_NAME, 'checkout', [
                    'action' => 'validatePhoneNumber',
                ]),
            ])
            ->addJavaScriptVariable(self::MISSING_PICKUP_POINT_ERROR, $this->translator->trans('Please select a pickup point.', [], 'Modules.Inpostinternational.Validators'));
    }
}
