<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout;

use InPost\International\Asset\Assets;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface CheckoutInterface extends EventSubscriberInterface
{
    public static function supports(\FrontControllerCore $controller, Request $request): bool;

    public function getAssets(): Assets;

    public function renderView(Request $request, \Cart $cart, int $carrierId): string;
}
