<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout;

use Doctrine\Common\Collections\Selectable;
use Doctrine\Persistence\ObjectRepository;
use InPost\International\Entity\CheckoutSession;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @extends ObjectRepository<CheckoutSession>
 * @extends Selectable<int, CheckoutSession>
 */
interface CheckoutSessionRepositoryInterface extends ObjectRepository, Selectable
{
    public function add(CheckoutSession $entity): void;

    public function remove(CheckoutSession $entity): void;
}
