<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Event;

use InPost\International\Hook\Event\AbstractActionHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class CarrierProcessEvent extends AbstractActionHook
{
    public const NAME = 'actionCarrierProcess';

    /**
     * @var \Cart
     */
    private $cart;

    public function __construct(\Cart $cart, Request $request)
    {
        $this->cart = $cart;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getRequest(): Request
    {
        return $this->request;
    }
}
