<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Event;

use InPost\International\Hook\Event\AbstractDisplayHook;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class DisplayCarrierContentEvent extends AbstractDisplayHook
{
    public const NAME = 'displayCarrierExtraContent';

    /**
     * @var array<string, mixed>
     */
    private $carrier;

    /**
     * @var \Cart
     */
    private $cart;

    /**
     * @param array<string, mixed> $carrier
     */
    public function __construct(array $carrier, \Cart $cart, Request $request)
    {
        $this->cart = $cart;
        $this->request = $request;
        $this->carrier = $carrier;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    /**
     * @return array<string, mixed>
     */
    public function getCarrier(): array
    {
        return $this->carrier;
    }

    public function getCarrierId(): int
    {
        return (int) ($this->carrier['id'] ?? 0);
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getRequest(): Request
    {
        return $this->request;
    }
}
