<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Event;

use InPost\International\Hook\Event\AbstractActionHook;
use InPost\International\Hook\Event\ParametersUpdatingHookInterface;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class StepCompleteValidationEvent extends AbstractActionHook implements ParametersUpdatingHookInterface
{
    public const NAME = 'actionValidateStepComplete';

    /**
     * @var string
     */
    private $stepName;

    /**
     * @var array
     */
    private $requestParams;

    /**
     * @var bool
     */
    private $completed;

    /**
     * @var \Cart
     */
    private $cart;

    /**
     * @param array<string, mixed> $request_params
     */
    public function __construct(string $step_name, array $request_params, bool $completed, \Cart $cart, Request $request)
    {
        $this->stepName = $step_name;
        $this->requestParams = $request_params;
        $this->completed = $completed;
        $this->cart = $cart;
        $this->request = $request;
    }

    public function getName(): string
    {
        return self::NAME;
    }

    public function getStepName(): string
    {
        return $this->stepName;
    }

    /**
     * @return array<string, mixed>
     */
    public function getRequestParameters(): array
    {
        return $this->requestParams;
    }

    public function isCompleted(): bool
    {
        return $this->completed;
    }

    public function setUncompleted(): void
    {
        $this->completed = false;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getRequest(): Request
    {
        return $this->request;
    }

    /**
     * {@inheritDoc}
     */
    public function updateParameters(array &$parameters): void
    {
        $parameters['completed'] = $this->completed;
    }
}
