<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Exception;

use PrestaShop\PrestaShop\Core\Module\Exception\ModuleErrorInterface;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AbortCheckoutException extends \RuntimeException implements ModuleErrorInterface
{
    /**
     * @var Response
     */
    private $response;

    public function __construct(Response $response, string $message = '', int $code = 0, \Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);

        $this->response = $response;
    }

    /**
     * @param mixed $data
     */
    public static function json($data, int $statusCode = Response::HTTP_UNPROCESSABLE_ENTITY, string $message = ''): self
    {
        $response = new JsonResponse($data, $statusCode);

        return new self($response, $message);
    }

    public function getResponse(): Response
    {
        return $this->response;
    }
}
