<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Exception;

use Symfony\Component\Form\FormErrorIterator;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class FormValidationException extends CheckoutException
{
    /**
     * @var FormErrorIterator
     */
    private $errors;

    public function __construct(FormErrorIterator $errors, string $message = '', int $code = 0, \Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
        $this->errors = $errors;
    }

    public static function create(FormErrorIterator $errors): self
    {
        return new self($errors, 'Form data is not valid.');
    }

    public function getErrors(): FormErrorIterator
    {
        return $this->errors;
    }
}
