<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Form;

use InPost\International\Checkout\Exception\CheckoutException;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface DeliveryFormHandlerInterface
{
    /**
     * @throws CheckoutException
     */
    public function handle(\Cart $cart, Request $request): void;
}
