<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Form;

use InPost\International\Entity\Carrier;
use Symfony\Component\Form\FormInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

interface DeliveryOptionsFormFactoryInterface
{
    public function getForCarrier(\Cart $cart, Carrier $carrier): ?FormInterface;

    /**
     * @param array<int, string> $deliveryOption comma separated lists of {@see \Carrier} IDs by address ID
     */
    public function getForDeliveryOption(\Cart $cart, array $deliveryOption): ?FormInterface;
}
