<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Form\Model;

use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PointDeliveryOptions
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank(message="Please select a pickup point.")
     */
    private $pointId;

    public function getPointId(): ?string
    {
        return $this->pointId;
    }

    public function setPointId(?string $pointId): void
    {
        $this->pointId = $pointId;
    }
}
