<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Form\Type;

use InPost\International\Checkout\Form\Model\PointDeliveryOptions;
use InPost\International\Country;
use InPost\International\Delivery\Validator\DeliveryPointId;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\Constraints\GroupSequence;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class PointDeliveryOptionsType extends AbstractType
{
    /**
     * @param array{country: Country} $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('pointId', HiddenType::class, [
            'required' => false,
            'attr' => [
                'data-country' => $options['country']->value,
                'class' => 'js-inpost-intl-selected-point-value',
            ],
            'constraints' => new DeliveryPointId([
                'country' => $options['country'],
                'groups' => 'api',
            ]),
            'validation_groups' => new GroupSequence([Constraint::DEFAULT_GROUP, 'api']),
        ]);
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver
            ->setDefaults([
                'data_class' => PointDeliveryOptions::class,
            ])
            ->setRequired('country')
            ->setAllowedTypes('country', Country::class);
    }
}
