<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Message;

use InPost\International\Checkout\Form\Model\PointDeliveryOptions;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class UpdateCheckoutSessionCommand
{
    /**
     * @var int
     */
    private $cartId;

    /**
     * @var array<int, PointDeliveryOptions>
     *
     * @Assert\Valid
     */
    private $deliveryOptions = [];

    public function __construct(int $cartId)
    {
        $this->cartId = $cartId;
    }

    public function getCartId(): int
    {
        return $this->cartId;
    }

    public function getDeliveryOptions(): array
    {
        return $this->deliveryOptions;
    }

    /**
     * @return PointDeliveryOptions|null
     */
    public function getCarrierOptions(int $carrierId): ?object
    {
        return $this->deliveryOptions[$carrierId] ?? null;
    }

    public function setPointDeliveryOptions(int $carrierId, PointDeliveryOptions $options): void
    {
        $this->deliveryOptions[$carrierId] = $options;
    }
}
