<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\Module\SuperCheckout;

use InPost\International\Checkout\Module\SuperCheckout;
use InPost\International\Hook\Event\Front\ControllerInitializedEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class FixRequestParamsListener implements EventSubscriberInterface
{
    public static function getSubscribedEvents(): array
    {
        return [
            ControllerInitializedEvent::NAME => 'onControllerInitialized',
        ];
    }

    public function onControllerInitialized(ControllerInitializedEvent $event): void
    {
        if (null === $request = $event->getRequest()) {
            return;
        }

        if (!SuperCheckout::supports($event->getController(), $request)) {
            return;
        }

        SuperCheckout::fixRequestParameters($request);
    }
}
