<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\View\Builder;

use InPost\International\Checkout\View\Model\CheckoutView;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ChainViewBuilder implements CheckoutViewBuilderInterface
{
    /**
     * @var iterable<CheckoutViewBuilderInterface>
     */
    private $builders;

    /**
     * @param iterable<CheckoutViewBuilderInterface> $builders
     */
    public function __construct(iterable $builders)
    {
        $this->builders = $builders;
    }

    public function buildView(CheckoutView $view): void
    {
        foreach ($this->builders as $builder) {
            $builder->buildView($view);
        }
    }
}
