<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\View\Builder;

use InPost\International\Checkout\View\Model\CheckoutView;
use InPost\International\Configuration\Enum\ClosestPointSearchMode;
use InPost\International\Configuration\Repository\CheckoutConfigurationRepositoryInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ConfigurationAwareClosestPointViewBuilder implements CheckoutViewBuilderInterface
{
    /**
     * @var CheckoutViewBuilderInterface
     */
    private $builder;

    /**
     * @var CheckoutConfigurationRepositoryInterface
     */
    private $configuration;

    public function __construct(CheckoutViewBuilderInterface $builder, CheckoutConfigurationRepositoryInterface $configuration)
    {
        $this->builder = $builder;
        $this->configuration = $configuration;
    }

    public function buildView(CheckoutView $view): void
    {
        $searchMode = $this->configuration->getCheckoutConfiguration()->getClosestPointSearchMode();

        if (ClosestPointSearchMode::Disabled() === $searchMode) {
            return;
        }

        $this->builder->buildView($view);
    }
}
