<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Checkout\View\Model;

use InPost\International\Entity\Carrier;
use Symfony\Component\Form\FormView;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @implements \ArrayAccess<string, mixed>
 */
final class CheckoutView implements \ArrayAccess
{
    /**
     * @var \Cart
     */
    private $cart;

    /**
     * @var Carrier
     */
    private $carrier;

    /**
     * @var int
     */
    private $carrierId;

    /**
     * @var FormView
     */
    private $form;

    /**
     * @var SelectedPointView
     */
    private $selectedPoint;

    /**
     * @var ClosestPointView
     */
    private $closestPoint;

    public function __construct(\Cart $cart, Carrier $carrier, int $carrierId, FormView $form)
    {
        $this->cart = $cart;
        $this->carrier = $carrier;
        $this->carrierId = $carrierId;
        $this->form = $form;
    }

    public function getCart(): \Cart
    {
        return $this->cart;
    }

    public function getForm(): FormView
    {
        return $this->form;
    }

    public function getCarrier(): Carrier
    {
        return $this->carrier;
    }

    public function getCarrierId(): int
    {
        return $this->carrierId;
    }

    public function getSelectedPoint(): ?SelectedPointView
    {
        return $this->selectedPoint;
    }

    public function setSelectedPoint(SelectedPointView $selectedPoint): void
    {
        $this->selectedPoint = $selectedPoint;
    }

    public function getClosestPoint(): ?ClosestPointView
    {
        return $this->closestPoint;
    }

    public function setClosestPoint(ClosestPointView $closestPoint): void
    {
        $this->closestPoint = $closestPoint;
    }

    public function offsetExists($offset): bool
    {
        return in_array($offset, [
            'form',
            'carrier_id',
            'selected_point',
            'closest_point',
        ]);
    }

    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        switch ($offset) {
            case 'form':
                return $this->form;
            case 'carrier_id':
                return $this->carrierId;
            case 'selected_point':
                return $this->selectedPoint;
            case 'closest_point':
                return $this->closestPoint;
            default:
                throw new \OutOfRangeException(sprintf('Undefined index "%s".', $offset));
        }
    }

    public function offsetSet($offset, $value): void
    {
        throw new \BadMethodCallException('Not supported.');
    }

    public function offsetUnset($offset): void
    {
        throw new \BadMethodCallException('Not supported.');
    }
}
