<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Clock;

use Psr\Clock\ClockInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class SystemClock implements ClockInterface
{
    /**
     * @var \DateTimeZone
     */
    private $timezone;

    public function __construct(\DateTimeZone $timezone)
    {
        $this->timezone = $timezone;
    }

    public static function fromSystemTimezone(): self
    {
        return new self(new \DateTimeZone(date_default_timezone_get()));
    }

    public function now(): \DateTimeImmutable
    {
        return new \DateTimeImmutable('now', $this->timezone);
    }
}
