<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Common\DTO;

use InPost\International\Country;
use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class Address
{
    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=128)
     */
    private $street;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=16)
     */
    private $houseNumber;

    /**
     * @var string|null
     *
     * @Assert\Length(max=16)
     */
    private $flatNumber;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=12)
     */
    private $postalCode;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=64)
     */
    private $city;

    /**
     * @var Country|null
     *
     * @Assert\NotBlank
     */
    private $countryCode;

    public function getCountryCode(): ?Country
    {
        return $this->countryCode;
    }

    public function setCountryCode(?Country $countryCode): self
    {
        $this->countryCode = $countryCode;

        return $this;
    }

    public function getPostalCode(): ?string
    {
        return $this->postalCode;
    }

    public function setPostalCode(?string $postalCode): self
    {
        $this->postalCode = $postalCode;

        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $city): self
    {
        $this->city = $city;

        return $this;
    }

    public function getStreet(): ?string
    {
        return $this->street;
    }

    public function setStreet(?string $street): self
    {
        $this->street = $street;

        return $this;
    }

    public function getHouseNumber(): ?string
    {
        return $this->houseNumber;
    }

    public function setHouseNumber(?string $houseNumber): self
    {
        $this->houseNumber = $houseNumber;

        return $this;
    }

    public function getFlatNumber(): ?string
    {
        return $this->flatNumber;
    }

    public function setFlatNumber(?string $flatNumber): self
    {
        $this->flatNumber = $flatNumber;

        return $this;
    }
}
