<?php
/**
 * Copyright since 2025 InPost S.A.
 *
 * For the full license information, please view the LICENSE file bundled with the module.
 *
 * @author InPost S.A.
 * @copyright since 2025 InPost S.A.
 * @license MIT
 */

declare(strict_types=1);

namespace InPost\International\Common\DTO;

use Symfony\Component\Validator\Constraints as Assert;

if (!defined('_PS_VERSION_')) {
    exit;
}

final class ContactDetails
{
    /**
     * @var string|null
     *
     * @Assert\Length(max=128)
     */
    private $companyName;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=64)
     */
    private $firstName;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Length(max=64)
     */
    private $lastName;

    /**
     * @var string|null
     *
     * @Assert\NotBlank
     * @Assert\Email
     * @Assert\Length(max=320)
     */
    private $email;

    /**
     * @var Phone|null
     *
     * @Assert\NotNull
     * @Assert\Valid
     */
    private $phone;

    public function getCompanyName(): ?string
    {
        return $this->companyName;
    }

    public function setCompanyName(?string $companyName): self
    {
        $this->companyName = $companyName;

        return $this;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(?string $email): self
    {
        $this->email = $email;

        return $this;
    }

    public function getPhone(): ?Phone
    {
        return $this->phone;
    }

    public function setPhone(?Phone $phone): self
    {
        $this->phone = $phone;

        return $this;
    }
}
